\1\3\43

  - Prevent a leak when allocating a large static buffer.
  - Fix edge case when using asn_pow() with a power of 2 modulus.
  - Fix having more than 3 arguments to a callout.

\1.3.42

  - Fix a memory alignment issue.
  - Handle events more efficiently.
  - Make limited edition more usable, but restrict it to 16 cores.

\1.3.41

  - Add call_out_summand().
  - Prevent a race condition when freeing objects.
  - Remove a program from the cache when recompiled.

\1.3.40

  - Scheduler improvements.
  - Cache pure programs.
  - Fix a bug in zero-length string handling.
  - Release the correct JIT-compiled instance.

\1.3.39

  - Separate uindex and CORef.
  - Make new_object() more efficient.
  - Make callout addition more efficient.
  - Make calling extension module functions more efficient.
  - Handle scheduling inconsistencies right at the start of a task.
  - Ensure that find_object() return values are consistent even while other
    tasks add objects.
  - Update extension API to version 1.5.
  - Fix verious scheduler issues.

\1.3.38

  - Callouts were not running correctly.

\1.3.37

  - Add ST_NUSERS to the status() array.
  - Enable > 64K users.

\1.3.36

  - Fix a sector leak.
  - Include current VM version in snapshot header.
  - Try to get more detailed type info for array aggregates.
  - Only improve checking for aggregates when typechecking >= 2.
  - Fix a bug that could prevent callout scheduling.
  - Permit a database wherever a snaphot is used.
  - Partially undo earlier change (1.3.32) to `parse_string()`.

\1.3.35

  - Increase binary input buffer size to 65535.
  - Permit non-string first argument for encryption.
  - Prefer IPv4 over IPv6 for outbound connections.
  - Handle instantaneous failure of socket `connect()`.
  - Too few nodes were allocated for a converted range switch.
  - Handle backslash at the end of an input buffer fragment.

\1.3.34

  - Avoid a race condition between commits and fast commits.
  - Handle encryption/decryption with more arguments.
  - Reset parser that has become too large.
  - Allow extension kfuns to replace native kfuns.
  - Add `O_SPECIAL` to the object status array.
  - Fix a race condition in outbound connections.
  - Allow a prototype to override an inherited non-matching prototype.

\1.3.33

  - Better errormessages.
  - Allow: `int /* \n */ #line 100 \n a;`
  - Faster commits for callout-started tasks that modify no other objects.

\1.3.32

  - Discard buffered output when `send_close()` is called.
  - Generate connect error codes in `connect.h`.
  - Let private inheritance fail object type check and cast.
  - Disambiguating by preferring the first rule did not always work.

\1.3.31

  - Include maximum catch depth in the program data.
  - Tidy up the database interface and get it working.

\1.3.30

  - Add kfun `send_close()`.
  - Properly handle a full-range switch.
  - Change directory before loading modules.
  - More string-related builtin kfuns.
  - Properly build the kfun prototype list for the JIT compiler.
  - Restrict hexadecimal escape sequences to 2 hexadecimal characters.

\1.3.29

  - Add kfun `asn_modinv()`.
  - Make the modulus of ASN kfuns optional.
  - Don't permit `"-"` to match `"%d"` or `"%f"`.
  - Better fix for `%f`.
  - Revert "Strip leading zeroes from asn_{and,or,xor} results."
  - Fix condition handling.
  - Discard conditions from inside a do loop.

\1.3.28

  - Handle a bad case as part of a list.
  - Change meaning of `I_STORES` and `I_CATCH`.
  - Only JIT-compile the current VM version.
  - Let `({ a, b }) = ({ 1, 2 })` have a value as an expression, after all.
  - Introduce `try { } catch (err) { }` as new syntax.

\1.3.27

  - Preserve cache affinity for idle CPUs.
  - Optimize object name hashing.
  - Optimize `call_trace[i][j]`.
  - Symbol hash should not be configurable.
  - Disallow `rename_file()` from atomically executed code.
  - Fix various float parsing problems.
  - Remove exception for deletion of objects being upgraded.
  - Handle `CKFUNC` differently.
  - `({ a, b }) = ({ 1, 2 })` should not have a value as an expression.
  - Use two-byte argument for `I_STORES`.
  - Closing channels with other modules was done from the wrong place.

\1.3.26

  - Proper tick accounting for JIT-compiled math code.

\1.3.25

  - Add builtin versions of math kfuns.

\1.3.24

  - Compare class properly in `?:`.
  - Fix the case where a LWO is both upgraded and touched.
  - Avoid needless float conversions for JIT-compiled code.

\1.3.23

  - `VM_SWITCH_INT` should pop non-int argument.
  - Handle `0` as `nil` in JIT-compiled string switch.

\1.3.22

  - Update snapshot format with 8-byte time.
  - Try to run at most one LPC thread per CPU core.
  - Pin LPC threads to CPU cores, whenever possible.
  - Utilize all available CPU groups on Windows.

\1.3.21

  - Avoid crash from faulty case label.
  - Fix a scheduler problem that could occur when a task was rescheduled many
    times.

\1.3.20

  - Fix `hash_string("MD5", ...)` and `hash_string("SHA1", ...)`.
  - Allow hash/encrypt/decrypt addon kfuns to override builtins.
  - Add `ext_runtime_check` to extension interface.
  - Permit typeless `operator` functions.
  - Strip leading zeroes from asn_{and,or,xor} results.

\1.3.19

  - Compile large switches without running out of memory.
  - Reset atomic inside a catch in JIT-compiled code.
  - Reverse binary search for JIT-compiled range switches.

\1.3.18

  - Update to extension interface 1.1.

\1.3.17

  - Support JIT compilation through the jit extension module.

\1.3.16

  - Handle `string + int + float` without runtime error.
  - Use ioctl instead of fcntl, so that binaries compiled on debian 10 will not
    depend on glibc 2.28.
  - Reduce the size of internal datastructures.

\1.3.15

  - Fix incoming datagram connection handling.
  - Detected and fixed some use-after-free cases.
  - Update to extension interface 0.12.

\1.3.14

  - Update to extension interface 0.11.
  - Add `connect_datagram()`.

\1.3.13

  - Properly terminate the name lookup thread at shutdown.
  - New version of `sscanf` doesn't call `i_lvalues()`.
  - Ensure that old snapshots converted by DGD 1.6.4+ can be restored.

\1.3.12

  - Wrapped up a number of performance enhancements begun after 1.3.1.

\1.3.11

  - Count loop ticks rather than instruction ticks.

\1.3.10

  - Implement peephole optimizer.
  - Update for LPC extensions 0.10.

\1.3.9

  - Revert "round to nearest, ties to even."
  - Use native floats to implement LPC floats.

\1.3.8

  - Don't add callouts in reverse order.
  - Fix a code generation bug.
  - Clarify errormessage for `({ a, b }) = nil`.
  - Increase configuration limits.

\1.3.7

  - Create full to-be-saved object copies before commit time, so that the commit
    thread has less work to do.

\1.3.6

  - Always generate positive 32-bit integer random numbers.
  - Prevent a crash when compiling a switch statement fails.

\1.3.5

  - Exclude some redundant data from snapshots.
  - Let `::var` refer to a non-local variable.
  - Have more `unconnected()` error codes.
  - Handle large shifts properly.
  - Let `random(0)` generate a full-int random number.

\1.3.4

  - Fix memory leak in indexed string assignment.
  - Introduce datagram connections, configured with optional parameters
    `datagram_port` and `datagram_users`.

\1.3.3

  - Write large swap items chunk by chunk.
  - Ensure that adding a callout to an object without reading its dataspace will
    in itself never result in a rollback.

\1.3.2

  - Start using `-1` as a symbol list terminator.
  - The `O_NSECTORS` field was not updated correctly for new/changed objects.
  - Perform more callout checks before a commit.

\1.3

  - Fixed a problem with arrays in callouts.
  - Properly close a binary connection after a read error.
  - Wait for the saver thread to exit when shutting down.
  - Fix some issues exposed by Solaris Studio 12.2.
  - Make sure to remove callouts from the right list.
  - thread => task, execution round => task, state dump => snapshot
  - Moved documentation into a
    [git submodule](git://lpc-doc.git.sourceforge.net/gitroot/lpc-doc/lpc-doc).
  - Fixed a bug in upgrading light-weight objects.
  - Re-enabling input with `block_input(0)` didn't always work.
  - Fixed a bug in creating a snapshot just after light-weight objects were
    upgraded.
  - Allow commit checks to be called mid-task.
  - Distinguish between file reading and file writing operations.  The latter
    will now switch the task to must-succeed mode.
  - Don't accept an incomplete secondary snapshot.
  - Keep track of the number of rollbacks per task.
  - Let `status(1)` return a different array, not yet used for anything.
  - Make the swaprate metric more useful.
  - Remove `MAX_STRING_SIZE` macro.
  - Predefine `__KFUN_FOO__` for all `foo()` kfuns.
  - Switch from predefined macros to generated include file `kfun.h`.
  - Add support for encryption/decryption/hashing extension modules.
  - Add list of ciphers and hashing algorithms to `kfun.h`.
  - `P_crypt()` must not use a static buffer for the result.
  - No comma after the last cipher/hash algorithm in `kfun.h`.
  - Add 2 to `MIN_STACK`, for `touch()`.
  - After a (currently hardcoded) number of tries, run a task in must-succeed
    mode.
  - Avoid out-of-stack errors on recursion in `ps_traverse()`.
  - Don't use alloca in `get_dir()`.
  - Add builtin kfuns for floats and strings.
  - Generate proper errormessage for bad optional argument.
  - Reorganize the compiler to use the new builtin kfuns, and to prepare
    for the new framework.
  - Fixed a bug that occurred when the order of strings in a partially saved
    object changed.
  - Prevent a buffer overflow in `kf_restore()`.
  - Store times in the callout table with the same offset as in objects.
  - Switch to 64 bit (48 bit seconds, 16 bit milliseconds) time internally.
  - Fixed a bug in the handling of floats in `kf_sum()`.
  - The size of an array is now held in a value of type `ArrSize`.
  - Add `O_INHERITED` and `O_INSTANTIATED` to `status(obj)`.
  - Fixed two instances where bad code was generated for the new builtin kfuns.
  - Distinguish between the LPC integer type and other internal integer types
    that used to have the same size.
  - Hydra can now be compiled for 64 bit LPC integers and 96 bit LPC floats.
    The old (and for Hydra, obsolete) instructions `0` and `1` are used for
    `I_INT8` and `I_DOUBLE`, respectively.  Big floats converted to strings
    have 18 digits of precision; for small floats, the number of digits is
    increased to 9.  Trigoniometric functions have not yet been adapted.
  - The internal precision for small floats was given as 10 digits, when it
    should have been 11 all along.
  - Allow snapshots created with small ints/floats to be restored by a server
    with big ints/floats, but not vice versa.  Integers will be expanded as
    signed values, and floats will be converted to the bigger format.
  - Add a (dummy, for the moment) argument to `shutdown()`.
  - Support 64 bit integers as case labels, too.
  - Handle large ints and floats in `save_object()` & `restore_object()`.
  - Fix several bugs in thread handling on Windows.
  - Ensure that mapping hashtable size doesn't overflow.
  - Switch to a new virtual machine for LPC bytecode.  The new VM does away
    with lvalues as a runtime value type.  The old VM is no longer supported.
  - Minimum required snapshot version increased to 14.
  - Permit a secondary snapshot to be partial, as well.
  - Preserve traverse link when copying a parser node.
  - Add a `connect(string address, int port)` kfun.
  - Don't allow `connect()` from a light-weight object.
  - Reserve `goto` as a keyword.
  - Various internal reorganizations.
  - Fix a corner case for indexed string assignment.
  - Implement `goto` statements, for easier translation to LPC.
  - Fixed a problem with variable initializers.
  - Fix performing a substitution inside an editor global command.
  - Fix callouts running in parallel with other tasks in the same object.
  - Fix a problem with arrays exported and removed from the original dataspace.
  - Fix a resource starvation issue with rescheduled tasks.
  - Fix a problem with restoring object types.
  - Fix a bug when an object is compiled, inherited and destructed in the same
    task.
  - Use a macro for typename buffer size.
  - Fix code generated for subexpressions with a guaranteed type.
  - Prepare editors for hotbooting.
  - Handle large integers and floats in the extension interface.
  - Add optional modules config parameter, remove command-line `-e` argument.
  - Optimize comma expressions correctly.
  - Fix a race condition in handling the first UDP packet after the challenge
    response.
  - Let `block_input()` also block UDP challenge response.
  - Under some conditions, concurrent snapshot reads could read wrong data.
  - Add optional `hotboot` config parameter.
  - Implement hotbooting on OSX, Linux and Solaris; not supported on Windows.
  - Let the editor handle `\0` in files.
  - Introduce a new VM instruction to handle `kfun(array...)`.
  - Update math functions for 96 bit floats.
  - Fix various bugs in hotbooting.
  - Stop complaining about memory fragmentation.
  - Handle DGD-generated incremental snapshots.
  - Enable memory management without reference counting.
  - Fix more bugs in hotbooting.
  - If `label::func()` is not found, try the auto object.
  - Fix object compiled and upgraded in the same task.
  - Purge template lists before creating a snapshot.
  - Accurately account for memory usage.
  - Fix a bug in the code optimizer.
  - Fix a problem in the scheduler that could cause a task to be repeated.
  - Prevent excessive numbers of object patches from being created.
  - Accept ellipsis for a function with no arguments.
  - Prevent a race condition in swap file handling.
  - Fix a bug with scheduled callouts.
  - Fix a problem in inheritance which allowed different issues of the same
    object to be inherited.
  - Load the right number of token and production rules in `ps_load()`.
  - Make sure that compiling an object twice in the same task works properly.
  - Fix a bug which could cause scheduled callouts to never run.
  - Don't deref twice when destructing an upgrading object.
  - Sometimes an attempt was made to load a dataspace where none existed.
  - Remove `O_INHERITED` and `O_INSTANTIATED` from `status(obj)`.
  - Increment `obj->update` only if there are clones.
  - Make it possible to have more than 256 kfuns.
  - Use proper typename buffer sizes.
  - Implement `operator` functions for light-weight objects.
  - Updates don't modify control blocks until commit time.
  - Use the right dataspace when restoring into a LWO.
  - Fix light-weight object upgrading when variables are added or removed.
  - Allow `mixed[any .. any]` again.
  - Fix inversion of character class.
  - Remove the swap cache, allowing direct I/O to and from sequential swap
    sectors in one system call.
  - Fix `catch` in atomic function.
  - Add extension interface support to use a database as a replacement for
    snapshots.
  - Permit an optional `object` keyword in `<-` and inheritance.
  - Fix bug in floating point subtraction.
  - Introduce `new "obj"`, `new object "obj"`, `new object "obj"()`.
  - Permit `inherit_program()` to compile from a different function.
  - Let `runtime_error()` and `atomic_error()` modify the error string.
  - Add a config parameter to module initialization.
  - Fix several bugs in linux socket handling.
  - Combine read and write events in solaris socket handling.
  - Add `STORE_FAR_GLOBAL_INDEX` instruction.
  - Add `INSTANCEOF` insstruction.
  - Add `STORES` instruction.
  - Fix incomplete kfx wipe.
  - Introduce `CTRL_VM_2_1` control block flag.
  - Don't translate object type in driver and auto objects.
  - Generate proper line numbers for local vars and ints.
  - Update extension interface for JIT compiler support.
  - Properly clean up stack when `sscanf` doesn't assign to array element.
  - Fix `rlimits (x; 0)`.
  - Add `ST1_SCHEDULER` and `ST1_SOLOTASKS`.
  - Dont check for destructed objects when copying values. Favour late checking
    over early checking.
  - Avoid modifying the editor command string, which may be shared.
  - Correct snapshot elapsed time accounting.
  - Ensure that the sector free list stays in range.
  - Use `htonl()` for `INADDR_*`.
  - Shutdown sockets before closing them.
  - Avoid putting an uninitialized value on the stack in a corner case.
  - Fix float rounding.
  - Use `off_t` for offets in `read_file()` and `write_file()`.
  - Fix string constants for `new`, `inherit`, and `instanceof`.
  - Add `instanceof` as a kfun.
  - Don't explicitly deallocate a faulty index.
  - Let `call_touch()` return `1` on success, `0` otherwise.
  - Fix memory leaks in `[]` and `[]=`.
  - Fix passing on initialized dataspace out of atomic rollback.
  - Fix crash after light-weight object upgrade.
  - Add missing path check to `get_dir()`.
  - Special treatment for `allocate()` in a summand.
  - LWOs could call static functions in their master.
  - Round to nearest, ties to even.

\1.2

  - Add a table of inherited variable types to the control block, to avoid
    some problematic dependencies.
  - Allow `o_access()` and `o_inherit()` to abort the current execution round if
    objects are found to be out of sync.
  - Make sure newly made objects have a unique name and destructed objects are
    not still found within the same execution round.
  - Fixed various MP consistency problems in `comm.c`.
  - Linux port complete.
  - Various communication, object and dataspace fixes for bugs that showed up
    during stress tests.
  - Merged the IPv4 and IPv6 connection code.
  - Wait for threads to finish before exiting.
  - Fixed linked lists in the name resolver.
  - Call `o_reset()` when running out of objects.
  - Fixed a bug in discarding objects.
  - And a nasty one in the memory allocator.
  - Some quick temporary fixes for the scheduler.
  - Ensure that the first message on a connection comes after the `open()` call
    completes.
  - Properly deal with 0 second callouts when creating a statedump.
  - The name lookup thread had a tendency to exit prematurely.
  - Fixed a variety of callout handling problems.
  - And another one.
  - Properly handle clones that are created and destructed in the same
    execution round.
  - Fixed a callout saving problem.
  - Fixed a bug in the string merge table.
  - The `instanceof` operator `<-` now returns `-1` for private inheritance.
  - Compress the table of inherited objects.
  - Simplify the object hashtable used during compilation.
  - Properly initialize objects added to the free list without being used.
  - Preserve the integrity of the free list when deleting an object upgrade
    template.
  - Handle more string constants in `parse_string()` grammars.
  - Prevent a crash when attempting to read a too-large chunk from a file.
  - Stop all use of instructions `I_PUSH_ZERO` and `I_PUSH_ONE`.
  - Kfuns now have a version number, to simplify upgrading.
  - Allow `({ a, b }) = array;` to facilitate returning multiple values from a
    function.
  - Generate the proper references to inherited global variables, which could
    be wrong since 1.1.15.
  - Enable incremental statedumps.
  - A full statedump following incremental statedumps would not be properly
    linked in the statedump file.
  - Get partial statedumps to work.
  - Fixed a bug which prevented callouts from running concurrently some of the
    time.
  - Ensure that a message is generated for every valid datagram received.
  - After a name lookup for an address fails, try again when the address is
    reused.
  - Moved saving of objects into a separate thread.
  - Remove character filtering for telnet connections.
  - Cleaned up the code that talks to the new data thread, and fixed two
    crashing bugs in there.
  - Moved copying of objects out of the main loop.
  - Moved retrieval of callout info out of the main loop.
  - When copying objects (just before a state dump, or from a secondary restore
    file), don't load them in memory all at once.
  - Do some housecleaning even for incremental statedumps.
  - When creating a (full) statedump, save objects in memory rather than
    swapping them out.
  - After `open_datagram()`, `open()` was mistakenly called as well.
  - Call `*_accept()` and `open()` in the same execution round.
  - Determine whether an execution round was valid before checking whether it
    can complete.
  - Don't rebuild dataspaces while they are in use.
  - Inverted conditional in `table.c`, pointed out by Bart van Leeuwen.
  - Ensure that modification flags are only cleared when the data is really
    saved.
  - Let `status()` return large numbers as floats.
  - Scheduler code cleaned up, and some stuck states eliminated.
  - The swap cache now handles multiple client threads better.
  - Fixed a number of serious swapping bugs.
  - Fixed a statedump bug in the scheduler.
  - Fixed a bug in destructing an object after compiling or upgrading it in the
    same execution round.
  - Made the scheduler a bit more efficient.
  - Don't commit to a replaced dataspace.
  - Corrected a problem in setting up the initial errorcontext.
  - Improvements in the extension interface and C code generator.
  - Don't save `parse_string()` automatons for special objects.
  - Add `htime` field to saved callouts.
  - DGDMP renamed to Hydra.
  - Sort the list of callouts to run by object.
  - Prevent objects from being saved independently while a statedump is in
    progress.
  - Finalized the internal callout API.
  - Fixed various bugs in managing callout lists.
  - Provide the interface utilized by the
    [LPC Extensions sourceforge project](http://lpc-ext.sourceforge.net/),
    version 0.5.
  - Upgrade to extension interface 0.6.
  - Include 8 byte ordering info in the dumpfile header.
  - Enable the new scheduler framework.
  - Put the version string at offset 42 in the dumpfile, rather than at
    offset 40.
  - Fixed several bugs in the scheduler.
  - Make message queues a little faster, and fork off the platform-independent
    code in a new source file.
  - Ported to Solaris.
  - Terminate the connection thread before closing connections upon exit.
  - Use a platform-independent pseudorandom number generator.
  - Fixed various pointer size and alignment issues.
  - Lock memory pools during clearing, so that `status()` doesn't report
    inconsistent results.
  - Ported to Windows.
  - Fixed some minor issues exposed by the Solaris and Windows ports.
  - Tune memory allocation for larger blocks.
  - Call `interrupt()` for program termination signals in Windows.
  - Use lightweight threads for non-LPC-running tasks, if supported by the host
    operating system.
  - Get datagrams to work.
  - Properly handle preprocessor errors while reading the config file.

\1.1

  - Made compiler reentrant.
  - After many rewrites, the code has stabilized.

\1.0

Differences with DGD:

  - multi-processor support
  - two-byte inheritor index support
  - dumpfile can be >= 2G
  - memory blocks can be >= 1G on hosts with `sizeof(size_t)` > 4
  - runs only on Darwin for now
  - a number of things don't work yet, but will soon
